# Web to Desktop framework comparison

This repository was made to create an objective comparison of multiple framework that grant us to "transform" our web app to desktop application formats.

## Table Of Content

- [Major characteristics](#major-characteristics)
- [Operating systems](#operating-systems)
- [Benchmarks](#benchmarks)
  - [01 - Empty app](#01---empty-app)
  - [02 - Empty app (Frameless)](#02---empty-app-frameless)

## Major characteristics

|                                    |                                          [Electron](https://github.com/electron/electron)                                           |                                                [NW.JS](https://github.com/nwjs/nw.js)                                                 |                           [Tauri](https://github.com/tauri-apps/tauri)                           |                                      [NodeGui](https://github.com/nodegui/nodegui)                                       |               [Neutralino](https://github.com/neutralinojs/neutralinojs)               |                   [Wails](https://github.com/wailsapp/wails)                   |                    [Flutter](https://github.com/flutter/flutter)                    |                                             [.Net MAUI](https://github.com/dotnet/maui)                                              |
| :--------------------------------: | :---------------------------------------------------------------------------------------------------------------------------------: | :-----------------------------------------------------------------------------------------------------------------------------------: | :----------------------------------------------------------------------------------------------: | :----------------------------------------------------------------------------------------------------------------------: | :------------------------------------------------------------------------------------: | :----------------------------------------------------------------------------: | :---------------------------------------------------------------------------------: | :----------------------------------------------------------------------------------------------------------------------------------: | ------ |
|          **Github stars**          |                                                                107k                                                                 |                                                                 39.6k                                                                 |                                              62.6k                                               |                                                           8.4k                                                           |                                          6.6k                                          |                                     15.4k                                      |                                       152.5k                                        |                                                                18.8k                                                                 | 18.8k  |
|             **Forks**              |                                                                14.6k                                                                |                                                                  4k                                                                   |                                               1.7k                                               |                                                           0.3k                                                           |                                          0.3k                                          |                                      0.7k                                      |                                        25.2k                                        |                                                                 1.3k                                                                 | 1.3k   |
|         **Creation date**          |                                                                2013                                                                 |                                                                 2011                                                                  |                                               2019                                               |                                                           2019                                                           |                                          2018                                          |                                      2019                                      |                                        2018                                         |                                                                 2020                                                                 |
|          **Last Update**           |                                                               4/2023                                                                |                                                                4/2023                                                                 |                                              4/2023                                              |                                                          4/2023                                                          |                                         4/2023                                         |                                     4/2023                                     |                                       4/2023                                        |                                                                4/2023                                                                | 4/2023 |
|       **Framework Language**       |                                                    C++, JS, Objective-C, Python                                                     |                                                                  C++                                                                  |                                               Rust                                               |                                                           C++                                                            |                                          C++                                           |                                       Go                                       |                                    C, C++, Dart                                     |                                                                  C#                                                                  |
|     **Usage Language - Back**      |                                                               JS, C++                                                               |                                                                JS, C++                                                                |                                               Rust                                               |                                                         JS, C++                                                          |                                        JS, C++                                         |                                       Go                                       |                                        Dart                                         |                                                                  C#                                                                  |
|     **Usage Language - Front**     |                                                            HTML, CSS, JS                                                            |                                                             HTML, CSS, JS                                                             |                                          HTML, CSS, JS                                           |                                                      HTML, CSS, JS                                                       |                                     HTML, CSS, JS                                      |                                 HTML, CSS, JS                                  |                                        Dart                                         |                                                                  C#                                                                  |
|            **License**             |                                   [MIT](https://github.com/electron/electron/blob/master/LICENSE)                                   |                                        [MIT](https://github.com/nwjs/nw.js/blob/nw52/LICENSE)                                         |                   [MIT](https://github.com/tauri-apps/tauri/blob/dev/LICENSE)                    |                              [MIT](https://github.com/nodegui/nodegui/blob/master/LICENSE)                               |        [MIT](https://github.com/neutralinojs/neutralinojs/blob/master/LICENSE)         |          [MIT](https://github.com/wailsapp/wails/blob/master/LICENSE)          |       [BSD 3-Clause](https://github.com/flutter/flutter/blob/master/LICENSE)        |                                       [MIT](https://github.com/dotnet/maui/blob/main/LICENSE)                                        |
|     **Developer Dependencies**     |                 [Node.js, Electron NPM Package](https://www.electronjs.org/docs/tutorial/quick-start#prerequisites)                 |                      [Node.js, NW.JS SDK](https://nwjs.readthedocs.io/en/latest/For%20Users/Getting%20Started/)                       | [C++ Compiler, Node.js, Rustc, Cargo](https://tauri.studio/docs/getting-started/prerequisites/)  | [Cmake, make, Node.js, NodeGUI NPM Package](https://docs.nodegui.org/docs/guides/getting-started/#developer-environment) | [Node.js, Neu NPM Package](https://neutralino.js.org/docs/#/gettingstarted/quickstart) | [Go 1.18+, Node 15+, Wails](https://wails.io/docs/gettingstarted/installation) | [Flutter SDK, Visual Studio 2019 / Clang](https://flutter.dev/desktop#requirements) |   [.Net SDK, Visual Studio (optional), WebView2 (optional), Xcode (optional)](https://github.com/dotnet/maui/wiki/Getting-Started)   |
|       **User Dependencies**        |                                                                None                                                                 |                                                                 None                                                                  |                                               None                                               |                                                           None                                                           |                                          None                                          |                                      None                                      |                                        None                                         |                                                                 None                                                                 |
| **Dependencies / modules support** |                                                     npm & node.js native addons                                                     |                                                      npm & node.js native addons                                                      |                                    cargo (back), npm (front)                                     |                                               npm & node.js native addons                                                |                                           ❌                                           |                           Gomod (back), npm (front)                            |                                       pub.dev                                       |                                                                NuGet                                                                 |
|             **Engine**             |                                                              Chromium                                                               |                                                           Webkit, Chromium                                                            |                WRY (WebKitGTK for Linux, WebKit for MacOS, Webview2 for Windows)                 |                                                            Qt                                                            |                                       WebkitGTK+                                       |                                     Webkit                                     |                                   Flutter engine                                    |                                                              .NET MAUI                                                               |
|      **Integrated updater ?**      |                               [Official](https://www.electronjs.org/fr/docs/latest/api/auto-updater)                                |                             [Community](https://docs.nwjs.io/en/latest/For%20Users/Advanced/Autoupdates/)                             |                 [Official](https://tauri.app/fr/v1/guides/distribution/updater/)                 |                                   [No](https://github.com/nodegui/nodegui/issues/678)                                    |            [Official](https://neutralino.js.org/docs/how-to/auto-updater/)             |            [Planned](https://github.com/wailsapp/wails/issues/1178)            |                        No, but there are community solutions                        |                                                                  No                                                                  |
|        **Automated Tests**         | Standard node.js tests (back-end) or [Webdriver/Playwright (UI)](https://www.electronjs.org/docs/latest/tutorial/automated-testing) | Standard node.js tests (back-end) or [Webdriver(UI)](https://docs.nwjs.io/en/latest/For%20Users/Advanced/Test%20with%20ChromeDriver/) | Cargo (back-end) or [Webdriver (UI)](https://tauri.app/v1/guides/testing/webdriver/introduction) |                                                            ?                                                             |                                           ?                                            |                                       ?                                        |                   [Integrated](https://docs.flutter.dev/testing)                    | [Standard C# tests (back-end), no official solution for UI](https://learn.microsoft.com/en-us/dotnet/architecture/maui/unit-testing) |

## Operating systems support

|                              |               | [Electron](https://github.com/electron/electron) |        [NW.JS](https://github.com/nwjs/nw.js)        | [Tauri](https://github.com/tauri-apps/tauri) | [NodeGui](https://github.com/nodegui/nodegui) | [Neutralino](https://github.com/neutralinojs/neutralinojs) |         [Wails](https://github.com/wailsapp/wails)         | [Flutter](https://github.com/flutter/flutter) | [.Net MAUI](https://github.com/dotnet/maui) |
| :--------------------------: | :-----------: | :----------------------------------------------: | :--------------------------------------------------: | :------------------------------------------: | :-------------------------------------------: | :--------------------------------------------------------: | :--------------------------------------------------------: | :-------------------------------------------: | :-----------------------------------------: |
| **Developement Environment** | **_Windows_** |                        ✔️                        |                          ✔️                          |                      ✔️                      |                      ✔️                       |                             ✔️                             |                             ✔️                             |                      ✔️                       |                     ✔️                      |
|                              |  **_MacOS_**  |                        ✔️                        |                          ✔️                          |                      ✔️                      |                      ✔️                       |                             ✔️                             |                             ✔️                             |                      ✔️                       |                     ✔️                      |
|                              |  **_Linux_**  |                  ✔️<sup>1</sup>                  |                          ✔️                          |                      ✔️                      |                      ✔️                       |                             ✔️                             |                             ✔️                             |                      ✔️                       |                     ✔️                      |
|    **Target Environment**    | **_Windows_** |                        ✔️                        |                          ✔️                          |                      ✔️                      |                      ✔️                       |                             ✔️                             |                             ✔️                             |                      ✔️                       |                     ✔️                      |
|                              |  **_MacOS_**  |                        ✔️                        |                          ✔️                          |                      ✔️                      |                      ✔️                       |                             ✔️                             |                             ✔️                             |                      ✔️                       |                     ✔️                      |
|                              |  **_Linux_**  |                        ✔️                        |                          ✔️                          |                      ✔️                      |                      ✔️                       |                             ✔️                             |                             ✔️                             |                      ✔️                       |                    Soon                     |
|                              | **_Android_** |                        ❌                        | [Requested](https://github.com/nwjs/nw.js/issues/94) |               Soon<sup>2</sup>               |                      ❌                       |                             ❌                             | [Requested](https://github.com/wailsapp/wails/issues/1481) |                      ✔️                       |                     ✔️                      |
|                              |   **_iOS_**   |                        ❌                        |                          ❌                          |           In progress<sup>2</sup>            |                      ❌                       |                             ❌                             | [Requested](https://github.com/wailsapp/wails/issues/1482) |                      ✔️                       |                     ✔️                      |
|                              |  **_tvOS_**   |                        ❌                        |                          ❌                          |                      ❌                      |                      ❌                       |                             ❌                             |                             ❌                             |                      ❌                       |                     ✔️                      |
|                              |   **_Web_**   |                        ❌                        |                          ❌                          |                      ❌                      |                      ❌                       |                       ✔️<sup>3</sup>                       |                             ❌                             |                      ✔️                       |                     ❌                      |

**<sup>1</sup>**: Linux 32 Bit support dropped  
**<sup>2</sup>**: https://github.com/tauri-apps/tauri#platforms  
**<sup>3</sup>**: Uses [modes](https://neutralino.js.org/docs/configuration/modes/) to generate web apps

## Benchmarks

**See [benchmarks.json](https://github.com/Elanis/web-to-desktop-framework-comparison/blob/main/runner/benchmarks.json) to get more informations about following data.**

_Note:_ These benchmarks are done on Github CI, there are measures to have measurements more accurates (e.g. multiple runs), but it will never exactly be accurate, as it totally depends on system load and resources. You should read these tables as comparision between frameworks on a same OS/Arch/App with a margin of error.

# 01-empty-app

See source in [benchmark/01-empty-app](https://github.com/Elanis/web-to-desktop-framework-comparison/tree/main/benchmark/01-empty-app/) folder.

### Build size

|                       | [Electron](https://github.com/electron/electron) |         [NW.JS](https://github.com/nwjs/nw.js)         | [Tauri](https://github.com/tauri-apps/tauri) | [NodeGui](https://github.com/nodegui/nodegui) | [Neutralino](https://github.com/neutralinojs/neutralinojs) | [Wails](https://github.com/wailsapp/wails) | [Flutter](https://github.com/flutter/flutter) | [.Net MAUI](https://github.com/dotnet/maui) | [.Net MAUI w/ Vue](https://github.com/dotnet/maui) |
| :-------------------: | :----------------------------------------------: | :----------------------------------------------------: | :------------------------------------------: | :-------------------------------------------: | :--------------------------------------------------------: | :----------------------------------------: | :-------------------------------------------: | :-----------------------------------------: | :------------------------------------------------: |
|  **_Windows (x64)_**  |                      ≈236MB                      |                         ≈334MB                         |                     ≈1MB                     |                    ≈171MB                     |                            ≈2MB                            |                    ≈8MB                    |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |
|  **_Windows (x86)_**  |                      ≈210MB                      |                         ≈301MB                         |                      ?                       |                       ?                       |                             ?                              |                     ?                      |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |
| **_Windows (ARM64)_** |                      ≈237MB                      | [Requested](https://github.com/nwjs/nw.js/issues/7599) |                      ?                       |                       ?                       |                             ?                              |                     ?                      |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |
|   **_MacOS (x64)_**   |                      ≈376MB                      |                         ≈508MB                         |                     ≈3MB                     |                       ?                       |                            ≈1MB                            |                    ≈7MB                    |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |
|  **_MacOS (arm64)_**  |                      ≈356MB                      |                           ?                            |                      ?                       |                       ?                       |                             ?                              |                     ?                      |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |
|   **_Linux (x64)_**   |                      ≈240MB                      |                         ≈442MB                         |                     ≈4MB                     |                     ≈75MB                     |                            ≈1MB                            |                    ≈6MB                    |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |
|   **_Linux (x86)_**   |                        ?                         |                         ≈441MB                         |                      ?                       |                       ?                       |                             ?                              |                     ?                      |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |
| **_Linux (ARMv7l)_**  |                      ≈176MB                      | [Requested](https://github.com/nwjs/nw.js/issues/1151) |                      ?                       |                       ?                       |                             ?                              |                     ?                      |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |
|  **_Linux (ARM64)_**  |                      ≈245MB                      | [Requested](https://github.com/nwjs/nw.js/issues/1151) |                      ?                       |                       ?                       |                            ≈1MB                            |                     ?                      |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |

### Build time

|                       | [Electron](https://github.com/electron/electron) |         [NW.JS](https://github.com/nwjs/nw.js)         | [Tauri](https://github.com/tauri-apps/tauri) | [NodeGui](https://github.com/nodegui/nodegui) | [Neutralino](https://github.com/neutralinojs/neutralinojs) | [Wails](https://github.com/wailsapp/wails) | [Flutter](https://github.com/flutter/flutter) | [.Net MAUI](https://github.com/dotnet/maui) | [.Net MAUI w/ Vue](https://github.com/dotnet/maui) |
| :-------------------: | :----------------------------------------------: | :----------------------------------------------------: | :------------------------------------------: | :-------------------------------------------: | :--------------------------------------------------------: | :----------------------------------------: | :-------------------------------------------: | :-----------------------------------------: | :------------------------------------------------: |
|  **_Windows (x64)_**  |                     ≈6052ms                      |                        ≈54217ms                        |                  ≈370160ms                   |                   ≈19369ms                    |                           ≈866ms                           |                  ≈15084ms                  |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |
|  **_Windows (x86)_**  |                     ≈6052ms                      |                        ≈54217ms                        |                      ?                       |                       ?                       |                             ?                              |                     ?                      |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |
| **_Windows (ARM64)_** |                     ≈6052ms                      | [Requested](https://github.com/nwjs/nw.js/issues/7599) |                      ?                       |                       ?                       |                             ?                              |                     ?                      |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |
|   **_MacOS (x64)_**   |                     ≈9225ms                      |                        ≈54217ms                        |                  ≈218289ms                   |                       ?                       |                           ≈908ms                           |                  ≈69468ms                  |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |
|  **_MacOS (arm64)_**  |                     ≈9225ms                      |                           ?                            |                      ?                       |                       ?                       |                             ?                              |                     ?                      |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |
|   **_Linux (x64)_**   |                     ≈2629ms                      |                        ≈54217ms                        |                  ≈308455ms                   |                    ≈9626ms                    |                           ≈908ms                           |                  ≈34591ms                  |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |
|   **_Linux (x86)_**   |                        ?                         |                        ≈54217ms                        |                      ?                       |                       ?                       |                             ?                              |                     ?                      |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |
| **_Linux (ARMv7l)_**  |                     ≈2629ms                      | [Requested](https://github.com/nwjs/nw.js/issues/1151) |                      ?                       |                       ?                       |                             ?                              |                     ?                      |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |
|  **_Linux (ARM64)_**  |                     ≈2629ms                      | [Requested](https://github.com/nwjs/nw.js/issues/1151) |                      ?                       |                       ?                       |                           ≈908ms                           |                     ?                      |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |

### Memory Usage

|                     | [Electron](https://github.com/electron/electron) | [NW.JS](https://github.com/nwjs/nw.js) | [Tauri](https://github.com/tauri-apps/tauri) | [NodeGui](https://github.com/nodegui/nodegui) | [Neutralino](https://github.com/neutralinojs/neutralinojs) | [Wails](https://github.com/wailsapp/wails) | [Flutter](https://github.com/flutter/flutter) | [.Net MAUI](https://github.com/dotnet/maui) | [.Net MAUI w/ Vue](https://github.com/dotnet/maui) |
| :-----------------: | :----------------------------------------------: | :------------------------------------: | :------------------------------------------: | :-------------------------------------------: | :--------------------------------------------------------: | :----------------------------------------: | :-------------------------------------------: | :-----------------------------------------: | :------------------------------------------------: |
| **_Windows (x64)_** |         ≈67MB (Debug) => ≈88MB (Release)         |   ≈102MB (Debug) => ≈40MB (Release)    |       ≈41MB (Debug) => ≈25MB (Release)       |                ≈123MB (Debug)                 |                       ≈69MB (Debug)                        |      ≈49MB (Debug) => ≈28MB (Release)      |                ≈274MB (Debug)                 |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |
|  **_MacOS (x64)_**  |         ≈66MB (Debug) => ≈65MB (Release)         |    ≈53MB (Debug) => ≈82MB (Release)    |       ≈50MB (Debug) => ≈29MB (Release)       |                ≈107MB (Debug)                 |              ≈77MB (Debug) => ≈28MB (Release)              |      ≈65MB (Debug) => ≈32MB (Release)      |                ≈186MB (Debug)                 |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |
|  **_Linux (x64)_**  |        ≈166MB (Debug) => ≈165MB (Release)        |             ≈96MB (Debug)              |      ≈116MB (Debug) => ≈83MB (Release)       |                ≈163MB (Debug)                 |             ≈198MB (Debug) => ≈216MB (Release)             |     ≈220MB (Debug) => ≈195MB (Release)     |                ≈399MB (Debug)                 |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |

### Start duration

|                     | [Electron](https://github.com/electron/electron) | [NW.JS](https://github.com/nwjs/nw.js) | [Tauri](https://github.com/tauri-apps/tauri) | [NodeGui](https://github.com/nodegui/nodegui) | [Neutralino](https://github.com/neutralinojs/neutralinojs) | [Wails](https://github.com/wailsapp/wails) | [Flutter](https://github.com/flutter/flutter) | [.Net MAUI](https://github.com/dotnet/maui) | [.Net MAUI w/ Vue](https://github.com/dotnet/maui) |
| :-----------------: | :----------------------------------------------: | :------------------------------------: | :------------------------------------------: | :-------------------------------------------: | :--------------------------------------------------------: | :----------------------------------------: | :-------------------------------------------: | :-----------------------------------------: | :------------------------------------------------: |
| **_Windows (x64)_** |       ≈2578ms (Debug) => ≈454ms (Release)        |           ≈1081ms (Release)            |     ≈5093ms (Debug) => ≈545ms (Release)      |                       ?                       |                             ?                              |   ≈19275ms (Debug) => ≈1279ms (Release)    |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |
|  **_MacOS (x64)_**  |       ≈2021ms (Debug) => ≈889ms (Release)        |           ≈1594ms (Release)            |     ≈5757ms (Debug) => ≈767ms (Release)      |                       ?                       |            ≈2416ms (Debug) => ≈893ms (Release)             |    ≈11690ms (Debug) => ≈950ms (Release)    |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |
|  **_Linux (x64)_**  |        ≈705ms (Debug) => ≈356ms (Release)        |                   ?                    |               ≈36834ms (Debug)               |                       ?                       |            ≈1638ms (Debug) => ≈450ms (Release)             |    ≈4471ms (Debug) => ≈372ms (Release)     |                       ?                       |               N/A<sup>1</sup>               |                  N/A<sup>2</sup>                   |

**<sup>1</sup>**: Benchmark WIP  
**<sup>2</sup>**: Benchmark WIP

# 02-empty-app-frameless

See source in [benchmark/02-empty-app-frameless](https://github.com/Elanis/web-to-desktop-framework-comparison/tree/main/benchmark/02-empty-app-frameless/) folder.

### Build size

|                       | [Electron](https://github.com/electron/electron) |         [NW.JS](https://github.com/nwjs/nw.js)         | [Tauri](https://github.com/tauri-apps/tauri) | [NodeGui](https://github.com/nodegui/nodegui) | [Neutralino](https://github.com/neutralinojs/neutralinojs) | [Wails](https://github.com/wailsapp/wails) | [Flutter](https://github.com/flutter/flutter) | [.Net MAUI](https://github.com/dotnet/maui) | [.Net MAUI w/ Vue](https://github.com/dotnet/maui) |
| :-------------------: | :----------------------------------------------: | :----------------------------------------------------: | :------------------------------------------: | :-------------------------------------------: | :--------------------------------------------------------: | :----------------------------------------: | :-------------------------------------------: | :-----------------------------------------: | :------------------------------------------------: |
|  **_Windows (x64)_**  |                      ≈236MB                      |                         ≈334MB                         |                     ≈1MB                     |                    ≈171MB                     |                            ≈2MB                            |                    ≈8MB                    |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |
|  **_Windows (x86)_**  |                      ≈210MB                      |                         ≈301MB                         |                      ?                       |                       ?                       |                             ?                              |                     ?                      |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |
| **_Windows (ARM64)_** |                      ≈237MB                      | [Requested](https://github.com/nwjs/nw.js/issues/7599) |                      ?                       |                       ?                       |                             ?                              |                     ?                      |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |
|   **_MacOS (x64)_**   |                      ≈376MB                      |                         ≈508MB                         |                     ≈3MB                     |                       ?                       |                            ≈1MB                            |                    ≈7MB                    |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |
|  **_MacOS (arm64)_**  |                      ≈356MB                      |                           ?                            |                      ?                       |                       ?                       |                             ?                              |                     ?                      |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |
|   **_Linux (x64)_**   |                      ≈240MB                      |                         ≈442MB                         |                     ≈4MB                     |                     ≈75MB                     |                            ≈1MB                            |                    ≈6MB                    |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |
|   **_Linux (x86)_**   |                        ?                         |                         ≈441MB                         |                      ?                       |                       ?                       |                             ?                              |                     ?                      |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |
| **_Linux (ARMv7l)_**  |                      ≈176MB                      | [Requested](https://github.com/nwjs/nw.js/issues/1151) |                      ?                       |                       ?                       |                             ?                              |                     ?                      |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |
|  **_Linux (ARM64)_**  |                      ≈245MB                      | [Requested](https://github.com/nwjs/nw.js/issues/1151) |                      ?                       |                       ?                       |                            ≈1MB                            |                     ?                      |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |

### Build time

|                       | [Electron](https://github.com/electron/electron) |         [NW.JS](https://github.com/nwjs/nw.js)         | [Tauri](https://github.com/tauri-apps/tauri) | [NodeGui](https://github.com/nodegui/nodegui) | [Neutralino](https://github.com/neutralinojs/neutralinojs) | [Wails](https://github.com/wailsapp/wails) | [Flutter](https://github.com/flutter/flutter) | [.Net MAUI](https://github.com/dotnet/maui) | [.Net MAUI w/ Vue](https://github.com/dotnet/maui) |
| :-------------------: | :----------------------------------------------: | :----------------------------------------------------: | :------------------------------------------: | :-------------------------------------------: | :--------------------------------------------------------: | :----------------------------------------: | :-------------------------------------------: | :-----------------------------------------: | :------------------------------------------------: |
|  **_Windows (x64)_**  |                     ≈6226ms                      |                        ≈31104ms                        |                  ≈389105ms                   |                   ≈19515ms                    |                           ≈643ms                           |                  ≈14378ms                  |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |
|  **_Windows (x86)_**  |                     ≈6226ms                      |                        ≈31104ms                        |                      ?                       |                       ?                       |                             ?                              |                     ?                      |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |
| **_Windows (ARM64)_** |                     ≈6226ms                      | [Requested](https://github.com/nwjs/nw.js/issues/7599) |                      ?                       |                       ?                       |                             ?                              |                     ?                      |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |
|   **_MacOS (x64)_**   |                     ≈17150ms                     |                        ≈31104ms                        |                  ≈265327ms                   |                       ?                       |                          ≈1091ms                           |                  ≈72964ms                  |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |
|  **_MacOS (arm64)_**  |                     ≈17150ms                     |                           ?                            |                      ?                       |                       ?                       |                             ?                              |                     ?                      |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |
|   **_Linux (x64)_**   |                     ≈3249ms                      |                        ≈31104ms                        |                  ≈378130ms                   |                   ≈12380ms                    |                          ≈1091ms                           |                  ≈46073ms                  |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |
|   **_Linux (x86)_**   |                        ?                         |                        ≈31104ms                        |                      ?                       |                       ?                       |                             ?                              |                     ?                      |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |
| **_Linux (ARMv7l)_**  |                     ≈3249ms                      | [Requested](https://github.com/nwjs/nw.js/issues/1151) |                      ?                       |                       ?                       |                             ?                              |                     ?                      |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |
|  **_Linux (ARM64)_**  |                     ≈3249ms                      | [Requested](https://github.com/nwjs/nw.js/issues/1151) |                      ?                       |                       ?                       |                          ≈1091ms                           |                     ?                      |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |

### Memory Usage

|                     | [Electron](https://github.com/electron/electron) | [NW.JS](https://github.com/nwjs/nw.js) | [Tauri](https://github.com/tauri-apps/tauri) | [NodeGui](https://github.com/nodegui/nodegui) | [Neutralino](https://github.com/neutralinojs/neutralinojs) | [Wails](https://github.com/wailsapp/wails) | [Flutter](https://github.com/flutter/flutter) | [.Net MAUI](https://github.com/dotnet/maui) | [.Net MAUI w/ Vue](https://github.com/dotnet/maui) |
| :-----------------: | :----------------------------------------------: | :------------------------------------: | :------------------------------------------: | :-------------------------------------------: | :--------------------------------------------------------: | :----------------------------------------: | :-------------------------------------------: | :-----------------------------------------: | :------------------------------------------------: |
| **_Windows (x64)_** |         ≈66MB (Debug) => ≈86MB (Release)         |    ≈78MB (Debug) => ≈51MB (Release)    |       ≈42MB (Debug) => ≈23MB (Release)       |                ≈115MB (Debug)                 |                       ≈60MB (Debug)                        |      ≈48MB (Debug) => ≈28MB (Release)      |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |
|  **_MacOS (x64)_**  |         ≈68MB (Debug) => ≈64MB (Release)         |    ≈88MB (Debug) => ≈80MB (Release)    |       ≈50MB (Debug) => ≈27MB (Release)       |                ≈114MB (Debug)                 |              ≈71MB (Debug) => ≈27MB (Release)              |      ≈66MB (Debug) => ≈30MB (Release)      |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |
|  **_Linux (x64)_**  |        ≈163MB (Debug) => ≈163MB (Release)        |             ≈90MB (Debug)              |      ≈109MB (Debug) => ≈82MB (Release)       |                ≈159MB (Debug)                 |             ≈197MB (Debug) => ≈214MB (Release)             |     ≈219MB (Debug) => ≈195MB (Release)     |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |

### Start duration

|                     | [Electron](https://github.com/electron/electron) | [NW.JS](https://github.com/nwjs/nw.js) | [Tauri](https://github.com/tauri-apps/tauri) | [NodeGui](https://github.com/nodegui/nodegui) | [Neutralino](https://github.com/neutralinojs/neutralinojs) | [Wails](https://github.com/wailsapp/wails) | [Flutter](https://github.com/flutter/flutter) | [.Net MAUI](https://github.com/dotnet/maui) | [.Net MAUI w/ Vue](https://github.com/dotnet/maui) |
| :-----------------: | :----------------------------------------------: | :------------------------------------: | :------------------------------------------: | :-------------------------------------------: | :--------------------------------------------------------: | :----------------------------------------: | :-------------------------------------------: | :-----------------------------------------: | :------------------------------------------------: |
| **_Windows (x64)_** |       ≈2496ms (Debug) => ≈422ms (Release)        |           ≈1067ms (Release)            |     ≈5073ms (Debug) => ≈509ms (Release)      |               ≈10963ms (Debug)                |                             ?                              |   ≈19271ms (Debug) => ≈1270ms (Release)    |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |
|  **_MacOS (x64)_**  |       ≈1987ms (Debug) => ≈1267ms (Release)       |           ≈1775ms (Release)            |     ≈6046ms (Debug) => ≈863ms (Release)      |                       ?                       |            ≈3550ms (Debug) => ≈1241ms (Release)            |    ≈9553ms (Debug) => ≈898ms (Release)     |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |
|  **_Linux (x64)_**  |        ≈806ms (Debug) => ≈415ms (Release)        |                   ?                    |               ≈42518ms (Debug)               |                       ?                       |            ≈2111ms (Debug) => ≈626ms (Release)             |    ≈5208ms (Debug) => ≈509ms (Release)     |                N/A<sup>1</sup>                |               N/A<sup>2</sup>               |                  N/A<sup>3</sup>                   |

**<sup>1</sup>**: Frameless mode not supported yet  
**<sup>2</sup>**: Frameless mode not working  
**<sup>3</sup>**: Frameless mode not working

## Future content

See [Issues](https://github.com/Elanis/web-to-desktop-framework-comparison/issues) and [Pull requests](https://github.com/Elanis/web-to-desktop-framework-comparison/pulls). You can participate by proposing new issues, of filling them !

## Contributors

[List of contributors to this repository](https://github.com/Elanis/web-to-desktop-framework-comparison/graphs/contributors)
